<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\TPU;

class SchedulingConfig extends \Google\Model
{
  /**
   * @var bool
   */
  public $preemptible;
  /**
   * @var bool
   */
  public $reserved;
  /**
   * @var bool
   */
  public $spot;

  /**
   * @param bool
   */
  public function setPreemptible($preemptible)
  {
    $this->preemptible = $preemptible;
  }
  /**
   * @return bool
   */
  public function getPreemptible()
  {
    return $this->preemptible;
  }
  /**
   * @param bool
   */
  public function setReserved($reserved)
  {
    $this->reserved = $reserved;
  }
  /**
   * @return bool
   */
  public function getReserved()
  {
    return $this->reserved;
  }
  /**
   * @param bool
   */
  public function setSpot($spot)
  {
    $this->spot = $spot;
  }
  /**
   * @return bool
   */
  public function getSpot()
  {
    return $this->spot;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(SchedulingConfig::class, 'Google_Service_TPU_SchedulingConfig');
