@extends($activeTemplate . 'layouts.master')
@section('content')
    <form action="">
        <div class="d-flex justify-content-end mb-4 flex-wrap gap-3">
            <div class="w-25">
                <select class="form-select form--control" name="property_status">
                    <option value="">@lang('Sell & Rent')</option>
                    <option value="1" @selected(request()->property_status == Status::BUY)>@lang('Sell')</option>
                    <option value="2" @selected(request()->property_status == Status::RENT)>@lang('Rent')</option>
                </select>
            </div>
            <button class="filter-btn btn btn--base" type="submit"> <i class="la la-filter"></i> @lang('Filter')</button>
        </div>

    </form>

    <table class="table--responsive--lg table">
        <thead>
            <tr>
                <th>@lang('Title') </th>
                <th>@lang('City')</th>
                <th>@lang('For')</th>
                <th>@lang('Price')</th>
                <th>@lang('Featured')</th>
                <th>@lang('Status')</th>
                <th>@lang('Actions')</th>
            </tr>
        </thead>
        <tbody>
            @forelse ($properties as $property)
                <tr>
                    <td>
                        <div>
                            <small class="text-muted">{{ __($property->category->name) }}</small>
                            <br>
                            <h6>{{ $property->title }}</h6>
                        </div>
                    </td>

                    <td> {{ $property->city->name }} <br>{{ $property->country->name }}</td>
                    <td>
                        @if ($property->property_status == Status::BUY)
                            <span class="badge badge--primary">@lang('Buy')</span>
                        @else
                            <span class="badge badge--base">@lang('Rent')</span>
                        @endif
                    </td>
                    <td> {{ showAmount($property->price) }} @if ($property->property_status == Status::RENT)
                            @lang('/ month')
                        @endif
                    </td>
                    <td> @php echo $property->featuredBadge; @endphp </td>
                    <td>@php echo $property->statusBadge @endphp</td>

                    <td>
                        <div class="d-flex justify-content-end flex-wrap gap-1">
                            <a class="btn btn--sm btn-outline--info" data-bs-toggle="tooltip" href="{{ route('user.property.edit', $property->id) }}" title="@lang('Edit Property')">
                                <i class="la la-pen"></i>
                            </a>
                            @if ($property->status == Status::PROPERTY_APPROVED)
                                <button class="btn btn-outline--danger btn--sm confirmationBtn" data-question="@lang('Are you sure to disable this property?')" data-action="{{ route('user.property.status', ['id' => $property->id, 'status' => Status::PROPERTY_DISABLED]) }}" data-bs-toggle="tooltip" title="@lang('Disable Property')">
                                    <i class="las la-ban"></i>
                                </button>
                            @elseif($property->status == Status::PROPERTY_DISABLED)
                                <button class="btn btn-outline--success confirmationBtn btn--sm" data-question="@lang('Are you sure to enable this property?')" data-action="{{ route('user.property.status', ['id' => $property->id, 'status' => Status::PROPERTY_APPROVED]) }}" data-bs-toggle="tooltip" title="@lang('Enable Property')">
                                    <i class="las la-check"></i>
                                </button>
                            @endif
                        </div>
                    </td>
                </tr>
            @empty
                <tr>
                    <td class="text-muted text-center" colspan="100%">
                        @include($activeTemplate . 'partials.empty', ['message' => 'No Property Created Yet!'])
                    </td>
                </tr>
            @endforelse
        </tbody>
    </table>
    @if ($properties->hasPages())
        @php echo paginateLinks($properties) @endphp
    @endif

    </div>
    <x-confirmation-modal />
@endsection
