@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="notice"></div>
    <div class="row gy-4">
        <div class="col-md-6">
            <div class="dashboard-widget">
                <div>
                    <h6 class="digit">{{ $data['total_property'] }}</h6>
                    <span class="caption"> @lang('Properties Added')</span>
                </div>
                <span class="icon bg--info text-white"><i class="la la-building"></i></span>
            </div>
        </div>

        <div class="col-md-6">
            <div class="dashboard-widget">
                <div>
                    <h6 class="digit">{{ $data['approved_property'] }}</h6>
                    <span class="caption"> @lang('Approved Properties')</span>
                </div>
                <span class="icon bg--success text-white"><i class="la la-check-circle"></i></span>
            </div>
        </div>

        <div class="col-md-6">
            <div class="dashboard-widget">
                <div>
                    <h6 class="digit">{{ $data['pending_property'] }}</h6>
                    <span class="caption"> @lang('Pending Properties')</span>
                </div>
                <span class="icon bg--warning text-black"><i class="la la-pause-circle"></i></span>
            </div>
        </div>

        <div class="col-md-6">
            <div class="dashboard-widget">
                <div>
                    <h6 class="digit">{{ $data['featured_property'] }}</h6>
                    <span class="caption"> @lang('Featured Properties')</span>
                </div>
                <span class="icon bg--base text-white"><i class="la la-star"></i></span>
            </div>
        </div>

        <div class="col-md-6">
            <div class="dashboard-widget">
                <div>
                    <h6 class="digit">{{ $data['disabled_property'] }}</h6>
                    <span class="caption"> @lang('Disabled Properties')</span>
                </div>
                <span class="icon bg--secondary text-white"><i class="la la-ban"></i></span>
            </div>
        </div>

        <div class="col-md-6">
            <div class="dashboard-widget">
                <div>
                    <h6 class="digit">{{ $data['rejected_property'] }}</h6>
                    <span class="caption"> @lang('Rejected Properties')</span>
                </div>
                <span class="icon bg--danger text-white"><i class="la la-times-circle"></i></span>
            </div>
        </div>
    </div>

    <div class="row mt-4">
        <h4>@lang('My Featured Properties')</h4>
        @if (!blank($properties))
            <table class="table table--responsive--lg">
                <thead>
                    <tr>
                        <th>@lang('Title') </th>
                        <th>@lang('City')</th>
                        <th>@lang('For')</th>
                        <th>@lang('Price')</th>
                        <th>@lang('Featured')</th>
                        <th>@lang('Status')</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($properties as $property)
                        <tr>
                            <td>
                                <div>
                                    <small class="text-muted">{{ __($property->category->name) }}</small>
                                    <br>
                                    <h6>{{ $property->title }}</h6>
                                </div>
                            </td>

                            <td>{{ $property->country->name }} <br> {{ $property->city->name }}</td>
                            <td>
                                @if ($property->property_status == Status::BUY)
                                    <span class="badge badge--primary">@lang('Buy')</span>
                                @else
                                    <span class="badge badge--base">@lang('Rent')</span>
                                @endif
                            </td>
                            <td> {{ showAmount($property->price) }}</td>
                            <td> @php echo $property->featuredBadge; @endphp </td>
                            <td>@php echo $property->statusBadge @endphp</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        @else
            @include($activeTemplate . 'partials.empty', ['message' => 'No Featured Property Found!'])
        @endif

    </div>
@endsection
