@php
    $content = getContent('login.content', true);
@endphp

@extends($activeTemplate . 'layouts.app')

@section('panel')
    <section class="account">
        <div class="account-inner">

            <div class="account-left">
                <div class="account-thumb">
                    <img src="{{ getImage('assets/images/frontend/login/' . @$content->data_values->image, '1120x930') }}" alt="">
                </div>
            </div>
            <div class="account-right">
                <div class="account-form-wrapper login">
                    <div class="account-form">
                        <div class="account-form__content">
                            <a class="account-form__logo" href="{{ route('home') }}">
                                <img src="{{ siteLogo()}}">
                            </a>
                            <h3 class="account-form__title mb-2"> {{ __($content->data_values->login_heading) }} </h3>
                            <p class="account-form__desc mb-3"> {{ __($content->data_values->login_subheading) }} </p>
                            @include($activeTemplate . 'partials.social_login')
                        </div>

                        <form class="verify-gcaptcha" method="POST" action="{{ route('user.login') }}">
                            @csrf
                            <div class="row">
                                <div class="col-lg-12 form-group group-two">
                                    <label class="form--label" for="email-six">@lang('Username or Email')</label>
                                    <input class="form--control control-two" id="email-six" name="username" type="text" value="{{ old('username') }}" required>
                                </div>
                                <div class="col-lg-12 form-group group-two">
                                    <label class="form--label" for="your-password">@lang('Password')</label>
                                    <div class="position-relative">
                                        <input class="form-control form--control control-two" id="your-password" name="password" type="password" required>
                                        <span class="password-show-hide fas fa-eye toggle-password fa-eye-slash" id="#your-password"></span>
                                    </div>
                                </div>

                                <x-captcha />

                                <div class="col-lg-12 form-group group-two">
                                    <div class="d-flex flex-wrap justify-content-between">
                                        <div class="form--check">
                                            <input class="form-check-input" id="remember" name="remember" type="checkbox" @checked(old('remember'))>
                                            <label class="form-check-label" for="remember">@lang('Remember me') </label>
                                        </div>
                                        <a class="forgot-password " href="{{ route('user.password.request') }}">@lang('Forgot Password?')</a>
                                    </div>
                                </div>
                                <div class="col-lg-12 form-group group-two">
                                    <button class="btn btn--base w-100" id="recaptcha" type="submit">@lang('Login')</button>
                                </div>
                                <div class="col-lg-12 ">
                                    <div class="have-account text-center">
                                        <p class="have-account__text">@lang('Don\'t have an account yet?') <a class="have-account__link text--base" href="{{ route('user.register') }}">@lang('Register')</a></p>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        </div>
    </section>
@endsection
