@php
    $teamContent = getContent('team.content', true);
    $teamElement = getContent('team.element', false, null, true);
@endphp
<section class="team-section gray-bg pt-120 pb-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="section-heading">
                    <h2 class="section-heading__title">{{ __($teamContent->data_values->heading) }}</h2>
                    <p class="section-heading__desc">{{ __($teamContent->data_values->subheading) }} </p>
                </div>
            </div>
        </div>
        <div class="row justify-content-center gy-4">
            @foreach ($teamElement as $team)
                <div class="col-lg-3 col-sm-6 col-xsm-6">
                    <div class="team-item ">
                        <div class="thumb">
                            <img src="{{ getImage('assets/images/frontend/team/' . @$team->data_values->image, '275x275') }}">
                        </div>

                        <div class="content base-bg">
                            <h5 class="name ">{{ @$team->data_values->name }}</h5>
                            <span class="designation ">{{ @$team->data_values->designation }}</span>
                        </div>
                    </div>
                </div>
            @endforeach

        </div>
    </div>
</section>
