@php
    $recentProContent = getContent('recent_properties.content', true);
    $properties = App\Models\Property::approved()
        ->whereHas('user.activePlan')
        ->with('category', 'city', 'country', 'user')
        ->orderBy('id', 'DESC')
        ->limit(9)
        ->get();
@endphp

@if (!blank($properties))
    <section class="listing-section py-120">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="section-heading">
                        <h2 class="section-heading__title"> {{ __(@$recentProContent->data_values->heading) }} </h2>
                        <p class="section-heading__desc"> {{ __(@$recentProContent->data_values->subheading) }}</p>
                    </div>
                </div>
            </div>
            <div class="row gy-4 justify-content-center">
                @include($activeTemplate . 'partials.property_grid', ['class' => 'col-lg-4 col-md-6'])
            </div>
        </div>
    </section>
@endif
