@php
    $cityContent = getContent('popular_city.content', true);
    $cityProperties = App\Models\City::active()
        ->where('is_featured', Status::CITY_FEATURED)
        ->withCount('properties')
        ->orderBy('properties_count', 'DESC')
        ->get();
@endphp

@if (!blank($cityProperties))
    <section class="city-section py-120">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="section-heading">
                        <h2 class="section-heading__title">{{ __(@$cityContent->data_values->heading) }}</h2>
                        <p class="section-heading__desc">{{ __(@$cityContent->data_values->subheading) }}</p>
                    </div>
                </div>
            </div>

            <div class="row justify-content-center gy-3">
                @forelse($cityProperties as $city)
                    <div class="col-lg-3 col-md-4 col-6">
                        <div class="location-item">
                            <a href="{{ route('properties') }}?city_id={{ $city->id }}" class="location-item__thumb">
                                <img src="{{ getImage(getFilePath('city') . '/' . $city->image, getFileSize('city')) }}">
                            </a>

                            <div class="location-item__content">
                                <span class="location-item__list">
                                    {{ getAmount($city->properties_count) }} @lang('Property')</span>
                                <h4 class="location-item__title mt-1">
                                    <a href="{{ route('properties') }}?city_id={{ $city->id }}" class="location-item__title-link">{{ __($city->name) }}</a>
                                </h4>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section>
@endif
