@php
    $categoryContent = getContent('category.content', true);
    $categories = App\Models\Category::active()
        ->where('is_featured', Status::CATEGORY_FEATURED)
        ->withCount('properties')
        ->get();
@endphp
@if (!blank($categories))
    <section class="category-section py-120 section-bg">
        <div class="category-section__shape-one">
            <img src="{{ asset($activeTemplateTrue . 'images/shapes/city-aside.png') }}">
        </div>
        <div class="category-section__shape-two">
            <img src="{{ asset($activeTemplateTrue . 'images/shapes/city-aside.png') }}">
        </div>
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="section-heading">
                        <h2 class="section-heading__title">{{ __(@$categoryContent->data_values->heading) }}</h2>
                        <p class="section-heading__desc">{{ __(@$categoryContent->data_values->subheading) }}</p>
                    </div>
                </div>
            </div>

            <div class="row gy-4 ">
                @forelse ($categories as $category)
                    <div class="col-lg-3 col-md-4 col-sm-6 col-xsm-6">
                        <div class="category-item">
                            <a href="{{ route('properties') }}?category_id={{ $category->id }}" class="category-item__thumb">
                                <img src="{{ getImage(getFilePath('category') . '/' . $category->image, getFileSize('category')) }}" alt="{{ __($category->name) }}">
                            </a>
                            <div class="category-item__content">
                                <span class="category-item__icon">
                                    @php echo $category->icon  @endphp
                                </span>
                                <a href="{{ route('properties') }}?search=&property_status=&category_id={{ $category->id }}&city_id="" class="category-item__title"> {{ __($category->name) }} </a>
                                <p class="category-item__number"> {{ getAmount($category->properties_count) }} </p>
                            </div>
                        </div>
                    </div>
                @empty
                    @lang('Property category not found!')
                @endforelse
            </div>
        </div>
    </section>
@endif
