@php
    $pricingContent = getContent('pricing.content', true);
@endphp
@extends($activeTemplate . 'layouts.frontend')
@section('content')
    <section class="pricing-section py-120 section-bg">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="section-heading">
                        <h2 class="section-heading__title"> {{ __($pricingContent->data_values->heading) }}</h2>
                        <p class="section-heading__desc">{{ __($pricingContent->data_values->subheading) }}</p>
                    </div>
                </div>
            </div>

            <div class="row gy-4">
                <div class="pricing-plan justify-content-center d-flex flex-wrap">
                    <button class="btn pricing-plan-btn active priceBtn" data-type="monthly">@lang('Monthly')</button>
                    <button class="btn pricing-plan-btn priceBtn" data-type="yearly">@lang('Yearly')</button>
                </div>

                @foreach ($plans as $plan)
                    <div class="col-lg-4 col-sm-6">
                        <div class="pricing-card ">
                            <div class="text-center">
                                <h6 class="pricing-card__title">{{ __($plan->title) }}</h6>
                                @if (auth()->user() && auth()->user()->activePlan && auth()->user()->activePlan->plan_id == $plan->id)
                                    <span class="current-plan-badge text-black">@lang('Current Plan')</span>
                                @endif
                            </div>

                            <h2 class="pricing-card__number monthlyPrice">
                                {{ showAmount($plan->monthly_price) }}<span class="time">/@lang('Month')</span>
                            </h2>

                            <h2 class="pricing-card__number yearlyPrice d-none">
                                {{ showAmount($plan->yearly_price) }}<span class="time">/@lang('Year')</span>
                            </h2>

                            <ul class="pricing-card__list">
                                <li class="pricing-card__item">
                                    <div class="d-flex justify-content-between">
                                        <span>
                                            <span class="pricing-card__item-icon text--success"><i
                                                    class="la la-check"></i></span>
                                            @lang('Properties can be added')
                                        </span>

                                        <span>{{ $plan->properties }} </span>
                                    </div>
                                </li>

                                <li class="pricing-card__item">
                                    <div class="d-flex justify-content-between">
                                        <span>
                                            <span
                                                class="pricing-card__item-icon @if ($plan->amenities) text--success @else text--danger @endif">
                                                <i
                                                    class="la @if ($plan->amenities) la-check @else la-times @endif"></i></span>
                                            @lang('Amenities per property')
                                        </span>
                                        <span>{{ $plan->amenities }} </span>
                                    </div>
                                </li>

                                <li class="pricing-card__item">
                                    <div class="d-flex justify-content-between">
                                        <span>
                                            <span class="pricing-card__item-icon">
                                                <i
                                                    class="la @if ($plan->images) text--success la-check @else text--danger la-times @endif"></i>
                                            </span>
                                            @lang('Images per property')
                                        </span>

                                        <span>{{ $plan->images }} </span>
                                    </div>
                                </li>

                                <li class="pricing-card__item">
                                    <div class="d-flex justify-content-between">
                                        <span>
                                            <span class="pricing-card__item-icon">
                                                <i
                                                    class="la @if ($plan->videos) text--success la-check @else text--danger la-times @endif"></i>
                                            </span>

                                            @lang('Videos per property')
                                        </span>

                                        <span>{{ $plan->videos }} </span>
                                    </div>
                                </li>

                                <li class="pricing-card__item">
                                    <div class="d-flex justify-content-between">
                                        <span>
                                            <span class="pricing-card__item-icon">
                                                <i
                                                    class="la @if ($plan->map) text--success la-check @else text--danger la-times @endif"></i>
                                            </span>
                                            @lang('Allow google map')
                                        </span>

                                        <span>
                                            @if ($plan->map)
                                                @lang('Yes')
                                            @else
                                                @lang('No')
                                            @endif
                                        </span>
                                    </div>
                                </li>
                            </ul>

                            @guest
                                <button class="btn pricing-card__button w-100 loginRequiredBtn mt-3"
                                    type="button">@lang('Buy Now')</button>
                            @else
                                <form action="{{ route('user.plan.choose', $plan->id) }}" class="mt-3" method=get">
                                    <input name="price_type" type="hidden" value="monthly">
                                    <button class="btn pricing-card__button w-100" type="submit">@lang('Buy Now')</button>
                                </form>
                            @endguest
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section>

    @if ($sections->secs != null)
        @foreach (json_decode($sections->secs) as $sec)
            @include($activeTemplate . 'sections.' . $sec)
        @endforeach
    @endif

@endsection


@push('modal')

    <div class="modal fade" id="loginRequired" aria-labelledby="exampleModalLabel" aria-hidden="true" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <h4 class="text-center mt-3 text--danger">@lang('This action requires login')</h4>
                    <div class="d-flex justify-content-center gap-2">
                        <button class="btn btn--sm btn--dark" data-bs-dismiss="modal" type="button"
                            aria-label="Close">@lang('Cancel')</button>
                        <a class="btn btn--sm btn--base" href="{{ route('user.login') }}">@lang('Login Now')</a>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";
            const modal = $('#loginRequired');
            $(document).on('click', '.loginRequiredBtn', function(e) {
                modal.modal('show');
            });

            $('.priceBtn').on('click', function() {
                $('.priceBtn').removeClass('active');

                if (!$(this).hasClass('active')) {
                    $(this).addClass('active');
                }

                let type = $(this).data('type');

                if (type === 'monthly') {
                    $('.monthlyPrice').removeClass('d-none');
                    $('.yearlyPrice').addClass('d-none');
                } else {
                    $('.yearlyPrice').removeClass('d-none');
                    $('.monthlyPrice').addClass('d-none');
                }

                $('[name=price_type]').each(function(index, element) {
                    element.value = type;
                });
            });
        })(jQuery);
    </script>
@endpush
