@foreach ($properties as $property)
    <div class="{{ $class }}">
        <div class="feature-item">
            <div class="feature-item__thumb">
                <a class="feature-item__thumb-link" href="{{ route('property.details', ['slug' => $property->category->slug, 'id' => $property->id]) }}">
                    <img src="{{ getImage(getFilePath('property') . '/' . $property->display_image, getFileSize('property')) }}">
                    <div class="location-item__content">
                        @if ($property->property_status == Status::BUY)
                            <span class="location-item__list buy">
                                @lang('Buy')
                            </span>
                        @else
                            <span class="location-item__list rent">
                                @lang('Rent')
                            </span>
                        @endif
                    </div>
                </a>
            </div>

            <div class="feature-item__content-wrapper d-flex justify-content-between flex-column flex-grow-1">
                <div class="feature-item__content">
                    <h6 class="text-muted mb-2 flex-between">
                        <span class="price">
                            {{ showAmount($property->price) }}
                        </span>

                        <span class="category">
                            @php
                                echo $property->category->icon;
                            @endphp
                            {{ __($property->category->name) }}
                        </span>
                    </h6>
                    <h5 class="feature-item__title ">
                        <a class="feature-item__link" href="{{ route('property.details', ['slug' => $property->category->slug, 'id' => $property->id]) }}">
                            {{ __(strLimit($property->title, 55)) }}
                        </a>
                    </h5>

                    <div class="flex-between">
                        <span class="fs-14">
                            <i class="la la-map-marker"></i> {{ __($property->location) }}
                        </span>

                        <span class="fs-14">
                            <i class="la la-city"></i> {{ __($property->city->name) }}, {{ __(@$property->country->name) }}
                        </span>
                    </div>
                </div>

                <div class="feature-item__contact flex-between">
                    <div class="feature-contact-wrapper">
                        <a class="text--body position-absolute h-100 w-100" href="mailto: {{ $property->user->email }}"></a>
                        <span class="feature-item__contact-icon">
                            <i class="las la-envelope"></i>
                        </span>
                        <span class="feature-item__contact-area">
                            @lang('Email')
                        </span>
                    </div>

                    <div class="feature-contact-wrapper">
                        <a class="text--body position-absolute h-100 w-100" href="tel: {{ $property->user->mobile }}"></a>
                        <span class="feature-item__contact-icon">
                            <i class="las la-phone"></i>
                        </span>
                        <span class="feature-item__contact-number">
                            @lang('Call')
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endforeach
