@php
    $footerContent = getContent('footer.content', true);
    $iconElement = getContent('social_icon.element', false, null, true);
    $policyPages = getContent('policy_pages.element', false, null, true);
    $contactElement = getContent('contact_us.element', false, 3, true);
@endphp
<footer class="footer-area">
    <div class="footer-area__shape-one">
        <img src="{{ asset($activeTemplateTrue . 'images/shapes/footer-1.png') }}">
    </div>
    <div class="footer-area__shape-two">
        <img src="{{ asset($activeTemplateTrue . 'images/shapes/footer-2.png') }}">
    </div>
    <div class="py-60">
        <div class="container">
            <div class="row gy-5">
                <div class="col-xl-4 col-sm-6">
                    <div class="footer-item">
                        <div class="footer-item__logo">
                            <a href="{{ route('home') }}"> <img src="{{ siteLogo('dark') }}" alt=""></a>
                        </div>
                        <p class="footer-item__desc"> {{ __(@$footerContent->data_values->content) }}</p>
                    </div>
                </div>
                <div class="col-xl-2 col-sm-6">
                    <div class="footer-item">
                        <h5 class="footer-item__title"> @lang('Quick Links') </h5>
                        <ul class="footer-menu">
                            @foreach ($policyPages as $link)
                                <li class="footer-menu__item"><a class="footer-menu__link" href="{{ route('policy.pages', [slug($link->data_values->title), $link->id]) }}">{{ __($link->data_values->title) }}</a></li>
                            @endforeach
                            <li class="footer-menu__item"><a class="footer-menu__link" href="{{ route('faq') }}">@lang('FAQ')</a></li>
                        </ul>
                    </div>
                </div>
                <div class="col-xl-2 col-sm-6">
                    <div class="footer-item">
                        <h5 class="footer-item__title">@lang('Important Links')</h5>
                        <ul class="footer-menu">
                            <li class="footer-menu__item"><a class="footer-menu__link" href="{{ route('properties') }}">
                                    @lang('Properties')</a>
                            </li>

                            <li class="footer-menu__item"><a class="footer-menu__link" href="{{ route('pricing') }}">@lang('Plan & Pricing')</a></li>
                            @if (@$pages)
                                @foreach ($pages as $k => $data)
                                    <li class="footer-menu__item">
                                        <a class="footer-menu__link" href="{{ route('pages', [$data->slug]) }}">{{ __($data->name) }}</a>
                                    </li>
                                @endforeach
                            @endif
                            <li class="footer-menu__item"><a class="footer-menu__link" href="{{ route('article') }}">@lang('Articles')</a></li>
                        </ul>
                    </div>
                </div>
                <div class="col-xl-3 col-sm-6">
                    <div class="footer-item">
                        <h5 class="footer-item__title">@lang('Contact With Us')</h5>
                        <ul class="footer-contact-menu">
                            @foreach ($contactElement as $contact)
                                <li class="footer-contact-menu__item">
                                    <div class="footer-contact-menu__item-icon">
                                        @php echo @$contact->data_values->icon @endphp
                                    </div>
                                    <div class="footer-contact-menu__item-content">
                                        <p>{{ @$contact->data_values->content }}</p>
                                    </div>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Footer Top End-->

    <!-- bottom Footer -->
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="bottom-footer">
                    <div class="bottom-footer-text text-white "> &copy; @lang('Copyright')
                        {{ date('Y') }}. <a class="base--text" href="{{ route('home') }}">{{ __(gs('site_name')) }}</a>
                        @lang('All rights reserved').</div>
                    <ul class="social-list">
                        @foreach ($iconElement as $icon)
                            <li class="social-list__item"><a class="social-list__link flex-center" href="{{ @$icon->data_values->url }}" target="_blank"> @php echo @$icon->data_values->social_icon; @endphp</a> </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    </div>
</footer>
