@php
    $contactContent = getContent('contact_us.content', true);
    $contactElement = getContent('contact_us.element', false, null, true);
@endphp
@extends($activeTemplate . 'layouts.frontend')
@section('content')
    <section class="contact-top py-120 section-bg">
        <div class="contact-top__shape-one">
            <img src="{{ asset($activeTemplateTrue . 'images/shapes/city-aside.png') }}">
        </div>
        <div class="contact-top__shape-two">
            <img src="{{ asset($activeTemplateTrue . 'images/shapes/city-aside.png') }}">
        </div>
        <div class="container">
            <div class="row gy-4 justify">
                @foreach ($contactElement as $contact)
                    <div class="col-md-4">
                        <div class="contact-item">
                            <div class="contact-item__top">
                                <div class="contact-item__icon">@php echo @$contact->data_values->icon @endphp</div>
                            </div>
                            <div class="contact-item__content">
                                <h5 class="contact-item__title"> {{ @$contact->data_values->title }} </h5>
                                <p class="contact-item__desc">{{ @$contact->data_values->content }}</p>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="contact-bottom section-bg">
                <div class="contact-wrapper">
                <div class="row gy-5">
                    <div class="col-lg-6">
                        <div class="contactus-form">
                            <h4 class="contact__title">{{ __(@$contactContent->data_values->heading) }}</h4>
                            <form class="verify-gcaptcha" action="" method="POST" autocomplete="off">
                                @csrf
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label class="form--label" for="name">@lang('Your Name')</label>
                                            <input class="form--control" id="name" name="name" type="text" value="{{ old('name', @$user->fullname) }}" @if ($user) readonly @endif required>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label class="form--label" for="adress">@lang('Your Email') </label>
                                            <input class="form--control" id="adress" name="email" type="email" value="{{ old('email', @$user->email) }}" @if ($user) readonly @endif required>
                                        </div>
                                    </div>
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="form--label" for="subject">@lang('Subject') </label>
                                            <input class="form--control" id="subject" name="subject" type="text" value="{{ old('subject') }}" required>
                                        </div>
                                    </div>
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="form--label" for="message">@lang('Message') </label>
                                            <textarea class="form--control" id="message" name="message" placeholder="@lang('Type message')" required>{{ old('message') }} </textarea>
                                        </div>
                                    </div>
                                    <x-captcha />
                                    <div class="col-sm-12">
                                        <div class="form-group mb-0">
                                            <button class=" btn btn--base" type="submit"> @lang('Send Message') </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="contact-map">
                            <iframe src="{{ @$contactContent->data_values->map }}" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                        </div>
                    </div>
                </div>
            </div>
            </div>
        </div>
    </section>

    @if ($sections->secs != null)
        @foreach (json_decode($sections->secs) as $sec)
            @include($activeTemplate . 'sections.' . $sec)
        @endforeach
    @endif
@endsection
