@extends($activeTemplate . 'layouts.frontend')
@section('content')
    <section class="blog py-120">
        <div class="container">
            <div class="row gy-4 justify-content-center">
                @foreach ($blogs as $blog)
                    <div class="col-lg-4 col-md-6">
                        <div class="blog-item">

                            <div class="blog-item__thumb">
                                <a class="blog-item__thumb-link"
                                    href="{{ route('article.details', ['slug' => $blog->slug]) }}">
                                    <img class="fit-image"
                                        src="{{ getImage('assets/images/frontend/article/thumb_' . @$blog->data_values->image, '435x260') }}">
                                </a>
                            </div>

                            <div class="blog-item__content">
                                <span class="text-list__item-icon me-1 text--base"><i class="las la-calendar"></i></span>
                                {{ showDateTime($blog->created_at, 'd F Y') }}
                                <h5 class="blog-item__title"><a class="blog-item__title-link border-effect"
                                        href="{{ route('article.details', ['slug' => $blog->slug]) }}">{{ strLimit(__($blog->data_values->title), 26) }}</a>
                                </h5>
                                <p>@php echo strLimit(strip_tags($blog->data_values->description_nic), 80); @endphp</p>

                                <a class="text--base mt-2"
                                    href="{{ route('article.details', ['slug' => $blog->slug]) }}">@lang('Read More')..</a>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            @if ($blogs->hasPages())
                <div class="row">
                    {{ paginateLinks($blogs) }}
                </div>
            @endif
        </div>
    </section>

    @if ($sections->secs != null)
        @foreach (json_decode($sections->secs) as $sec)
            @include($activeTemplate . 'sections.' . $sec)
        @endforeach
    @endif
@endsection
