@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-md-12">
            <div class="card b-radius--10">
                <div class="card-body p-0">
                    <div class="table-responsive--md table-responsive">
                        <table class="table--light style--two table">
                            <thead>
                                <tr>
                                    <th>@lang('Property')</th>
                                    <th>@lang('Type') | @lang('Category')</th>
                                    <th>@lang('Price') | @lang('User')</th>
                                    <th>@lang('Is Featured')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>

                            <tbody>
                                @forelse($properties as $property)
                                    <tr>

                                        <td class="text-start">
                                            <div class="d-flex justify-content-end justify-content-lg-start flex-wrap">
                                                <span class="avatar avatar--xs me-2">
                                                    <img src="{{ getImage(getFilePath('property') . '/' . $property->display_image, getFileSize('property')) }}">
                                                </span>

                                                <span>
                                                    {{ strLimit(__($property->title), 40) }}
                                                    <br>
                                                    <em class="text-muted">
                                                        <i class="la la-map-marker-alt"></i>{{ strLimit(__($property->city->name), 30) }}, {{ strLimit(__($property->country->name), 30) }}
                                                    </em>
                                                </span>
                                            </div>
                                        </td>

                                        <td>
                                            @if ($property->property_status == Status::BUY)
                                                <span class="badge bg--primary">@lang('Buy')</span>
                                            @else
                                                <span class="badge bg--success">@lang('Rent')</span>
                                            @endif
                                            <br>
                                            {{ __($property->category->name) }}
                                        </td>

                                        <td>
                                            {{ showAmount($property->price) }} @if ($property->property_status == Status::RENT)
                                                @lang('/ month')
                                            @endif
                                            <br>
                                            <a href="{{ route('admin.users.detail', $property->user->id) }}"><span>@</span>{{ $property->user->username }}</a>
                                        </td>

                                        <td>
                                            @php  echo  $property->featuredBadge;  @endphp
                                        </td>

                                        <td>
                                            @php  echo  $property->statusBadge;  @endphp
                                        </td>

                                        <td>
                                            <div class="d-flex justify-content-end flex-wrap gap-1">
                                                <a class="btn btn-outline--primary btn-sm" href="{{ route('admin.property.details', $property->id) }}">
                                                    <i class="las la-desktop"></i>@lang('Details')
                                                </a>

                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
                @if ($properties->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($properties) }}
                    </div>
                @endif
            </div>
        </div>
    </div>

    <x-confirmation-modal />
@endsection
@push('breadcrumb-plugins')
    <x-search-form propertyType="yes" />
@endpush
@push('script')
    <script>
        $('select').on('change', function() {
            let form = $('.property-filter');
            form.submit();
        });
    </script>
@endpush
