@extends('admin.layouts.app')
@section('panel')
    <div class="row gy-4">
        <div class="col-12">
            <div class="d-flex justify-content-end gap-2">
                @if ($property->status == Status::PROPERTY_PENDING)
                    <button class="btn btn-outline--danger confirmationBtn" data-action="{{ route('admin.property.reject', $property->id) }}" data-question="@lang('Are you sure to reject this property')?" type="button">
                        <i class="la la-times"></i>@lang('Reject')
                    </button>

                    <button class="btn btn-outline--success confirmationBtn" data-action="{{ route('admin.property.approve', $property->id) }}" data-question="@lang('Are you sure to approve this property')?" type="button" @disabled(@$userPlan->properties < @$approvedTotal)>
                        <i class="la la-check"></i>@lang('Approve')
                    </button>
                @endif

                @if (!($property->status == Status::PROPERTY_DISABLED || $property->status == Status::PROPERTY_REJECTED))
                    @if ($property->is_featured == Status::PROPERTY_FEATURED)
                        <button class="btn btn-outline--dark btn-sm confirmationBtn" data-question="@lang('Are you sure to unfeature this property?')" data-action="{{ route('admin.property.feature', $property->id) }}">
                            <i class="las la-eye-slash"></i>@lang('Remove form featured')
                        </button>
                    @else
                        <button class="btn btn-outline--primary confirmationBtn btn-sm" data-question="@lang('Are you sure to feature this property?')" data-action="{{ route('admin.property.feature', $property->id) }}">
                            <i class="las la-eye"></i>@lang('Make Feature')
                        </button>
                    @endif
                @endif
            </div>
        </div>
        <div class="col-lg-7">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">@lang('Property Details')</h5>
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item">
                            <span class="text--muted">@lang('Owner')</span>
                            <h6 class="text--primary"><a href="{{ route('admin.users.detail', $property->user_id) }}">{{ $property->user->username }}</a></h6>
                        </li>

                        <li class="list-group-item">
                            <span class="text--muted">@lang('For')</span>
                            <h6>
                                @if ($property->property_status == Status::BUY)
                                    <span class="badge bg--info">
                                        <h6 class="text-white">@lang('Sell')</h6>
                                    </span>
                                @else
                                    <span class="badge bg--warning">
                                        <h6 class="text-white">@lang('Rent')</h6>
                                    </span>
                                @endif
                            </h6>
                        </li>

                        <li class="list-group-item">
                            <span class="text--muted">@lang('Property Id')</span>
                            <h6>#{{ $property->property_id }}</h6>
                        </li>

                        <li class="list-group-item">
                            <span class="text--muted">@lang('Title')</span>
                            <h6>{{ __($property->title) }}</h6>
                        </li>

                        <li class="list-group-item">
                            <span class="text--muted">@lang('Location')</span>
                            <h6>{{ __($property->location) }}</h6>
                        </li>
                        <li class="list-group-item">
                            <span class="text--muted">@lang('City')</span>
                            <h6>{{ __($property->city->name) }}</h6>
                        </li>
                        <li class="list-group-item">
                            <span class="text--muted">@lang('Country')</span>
                            <h6>{{ __($property->country->name) }}</h6>
                        </li>


                        <li class="list-group-item">
                            <span class="text--muted">@lang('Total Area')</span>
                            <h6>{{ @$property->total_area }} @lang('sqft')</h6>
                        </li>

                        <li class="list-group-item">
                            <span class="text--muted">@lang('Price')</span>
                            <h6>{{ showAmount($property->price) }}</h6>
                        </li>

                        <li class="list-group-item">
                            <span class="text--muted">@lang('Category')</span>
                            <h6>{{ __($property->category->name) }}</h6>
                        </li>

                        @if ($property->tag)
                            <li class="list-group-item">
                                <span>@lang('Tags')</span>

                                <div>
                                    @foreach ($property->tags as $tags)
                                        <span class="badge badge--primary">{{ $tags }}</span>
                                    @endforeach

                                </div>
                            </li>
                        @endif
                    </ul>
                </div>
            </div>

            @if (!blank($property->amenities))
                <div class="card mt-3">
                    <div class="card-body">
                        <h5 class="card-title d-flex align-items-center gap-2">@lang('Amenities') <span class="badge bg--info">{{ count($property->amenities) }}/{{ $userPlan->amenities ?? 0 }}</span></h5>

                        <ul class="list-group list-group-flush">
                            @foreach ($property->amenities as $amenity)
                                <li class="list-group-item">
                                    <span>{{ __($amenity->name) }}</span> <span> {{ __($amenity->value) }}</span>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            @endif

            <div class="card mt-3">
                <div class="card-body">
                    <h5 class="card-title">@lang('Office Schedule')</h5>
                    <ul class="list-group list-group-flush">

                        @if ($property->open_time)
                            <li class="list-group-item">
                                <span>@lang('Open at')</span>
                                <span>{{ showDateTime($property->open_time, 'h:i A') }}</span>
                            </li>
                        @endif

                        @if ($property->close_time)
                            <li class="list-group-item">
                                <span>@lang('Closed at')</span>
                                <span>{{ showDateTime($property->close_time, 'h:i A') }}</span>
                            </li>
                        @endif

                        @if (!blank($property->day_off))
                            <li class="list-group-item">
                                <span>@lang('Day Off')</span>
                                @php
                                    $property->day_off = array_map(function ($day) {
                                        return ucfirst($day);
                                    }, $property->day_off);
                                @endphp

                                <span>
                                    {{ implode(', ', $property->day_off) }}
                                </span>
                            </li>
                        @endif
                    </ul>
                </div>
            </div>

            <div class="card mt-3">
                <div class="card-body">
                    <h5 class="card-title">@lang('Property Description')</h5>
                    <p> @php  echo $property->description; @endphp</p>
                </div>
            </div>
        </div>

        <div class="col-lg-5">

            <div class="card mb-3">
                <div class="card-body">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item d-flex justify-content-between">
                            <span class="text--muted">@lang('Status')</span>
                            @php echo $property->statusBadge; @endphp
                        </li>

                        <li class="list-group-item d-flex justify-content-between">
                            <span class="text--muted">@lang('Featured')</span>
                            <div>
                                @if ($property->is_featured == Status::PROPERTY_FEATURED)
                                    <span class="badge badge--success">@lang('Yes')</span>
                                @else
                                    <span class="badge badge--danger">@lang('No')</span>
                                @endif
                            </div>
                        </li>

                        <li class="list-group-item d-flex justify-content-between">
                            <span class="text-muted">@lang('Approved Properties')</span> <span> {{ $totalApproved }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <span class="text-muted">@lang('Allowed Properties')</span> <span>{{ $userPlan->properties ?? 0 }}</span>
                        </li>
                    </ul>
                </div>
            </div>

            @if ($property->map)
                <div class="card mb-3">
                    <div class="card-body">
                        <h5 class="card-title"> @lang('Map') </h5>
                        <iframe src="{{ $property->map }}" style="border:0;" width="100%" height="300" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                    </div>
                </div>
            @endif

            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">@lang('Display Image')</h5>
                    <div class="row">
                        <div class="col-sm-4">
                            <a class="gallery-thumb" href="{{ getImage(getFilePath('property') . '/' . $property->display_image, getFileSize('property')) }}">
                                <img class="mw-100" src="{{ getImage(getFilePath('property') . '/' . $property->display_image, getFileSize('property')) }}" alt="">
                            </a>
                        </div>
                    </div>

                    <h5 class="card-title d-flex align-items-center mt-3 gap-2">@lang('Gallery Images') <span class="badge bg--info">{{ $property->images->count() }}/{{ $userPlan->images ?? 0 }}</span></h5>

                    @if (!blank($property->images))
                        <div class="row gy-4">
                            @foreach ($property->images as $image)
                                <div class="col-sm-4">
                                    <a class="gallery-thumb" href="{{ getImage(getFilePath('property') . '/' . $image->name, getFileSize('property')) }}">
                                        <img class="mw-100" src="{{ getImage(getFilePath('property') . '/' . $image->name, getFileSize('property')) }}" alt="">
                                    </a>
                                </div>
                            @endforeach
                        </div>
                    @endif
                </div>
            </div>

            @if (!blank($property->videos))
                <div class="card mt-3">
                    <div class="card-body">
                        <h5 class="card-title d-flex align-items-center gap-2">@lang('Videos') <span class="badge bg--info">{{ count($property->videos) }}/{{ $userPlan->videos ?? 0 }}</span></h5>

                        @foreach ($property->videos as $video)
                            <iframe class="video mw-100" src="{{ @$video }}" title="YouTube video player" width="100%" height="350" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>
                        @endforeach
                    </div>
                </div>
            @endif
        </div>
    </div>
    <x-confirmation-modal />
@endsection

@push('breadcrumb-plugins')
    <x-back route="{{ route('admin.property.index') }}" />
@endpush

@push('style')
    <style>
        .list-group-item {
            display: flex;
            flex-wrap: wrap;
            justify-content: space-between;
            align-items: center;
            padding: .8rem 0;
            border: 1px solid #f1f1f1;
        }
    </style>
@endpush
