@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('S.N.')</th>
                                    <th>@lang('Name')</th>
                                    <th>@lang('Cities')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($countries as $country)
                                    <tr>
                                        <td>{{ $countries->firstItem() + $loop->index }}</td>
                                        <td>
                                            {{ __($country->name) }}
                                        </td>
                                        <td>
                                            <span class="badge @if ($country->cities_count) badge--primary @else badge--dark @endif">{{ $country->cities_count }}</span>
                                        </td>
                                        <td>
                                            @php echo $country->statusBadge; @endphp
                                        </td>
                                        <td>
                                            <div class="button--group">
                                            <button class="btn btn-sm btn-outline--primary editBtn cuModalBtn" data-resource="{{ $country }}" data-modal_title="@lang('Edit Country')" data-has_status="1" type="button">
                                                <i class="la la-pencil"></i>@lang('Edit')
                                            </button>
                                            @if ($country->status == Status::ENABLE)
                                                <button class="btn btn-outline--danger btn-sm confirmationBtn" data-question="@lang('Are you sure to disable this country?')" data-action="{{ route('admin.country.status', $country->id) }}">
                                                    <i class="las la-eye-slash"></i>@lang('Disable')
                                                </button>
                                            @else
                                                <button class="btn btn-outline--success confirmationBtn btn-sm" data-question="@lang('Are you sure to enable this country?')" data-action="{{ route('admin.country.status', $country->id) }}">
                                                    <i class="las la-eye"></i>@lang('Enable')
                                                </button>
                                            @endif
                                            </div>

                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>

                @if ($countries->hasPages())
                    <div class="card-footer py-4">
                        @php echo paginateLinks($countries) @endphp
                    </div>
                @endif
            </div><!-- card end -->
        </div>
    </div>

    <!--Cu Modal -->
    <div class="modal fade" id="cuModal" role="dialog" tabindex="-1">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <button class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form action="{{ route('admin.country.store') }}" method="POST">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <label>@lang('Name')</label>
                            <select class="form-control select2" name="name">
                                <option disabled selected>@lang('Select Country')</option>
                                @foreach ($allCountries as $data)
                                    <option value="{{ $data->country }}"> {{ __($data->country) }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn--primary h-45 w-100" type="submit">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <x-confirmation-modal />
@endsection

@push('breadcrumb-plugins')
    <x-search-form />
    <button class="btn btn-sm btn-outline--primary h-45 cuModalBtn" data-modal_title="@lang('Add New Country')" type="button">
        <i class="las la-plus"></i>@lang('Add New')
    </button>
@endpush
