@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table--light style--two table">
                            <thead>
                                <tr>
                                    <th>@lang('S.N.')</th>
                                    <th>@lang('Name')</th>
                                    <th>@lang('Country')</th>
                                    <th>@lang('Properties')</th>
                                    <th>@lang('Is Featured')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($cities as $city)
                                    <tr>
                                        <td>{{ $cities->firstItem() + $loop->index }}</td>
                                        <td>
                                            <span class="d-block avatar avatar--xs">
                                                <img  src="{{ getImage(getFilePath('city') . '/' . $city->image, getFileSize('city')) }}">
                                            </span>
                                            {{ __($city->name) }}
                                        </td>
                                        <td>
                                            {{ __($city->country->name) }}
                                        </td>
                                        <td>
                                            <span
                                                class="badge @if ($city->properties_count) badge--primary @else badge--dark @endif">{{ getAmount($city->properties_count) }}</span>
                                        </td>
                                        <td>
                                            @if ($city->is_featured == Status::CITY_FEATURED)
                                                <span class="badge badge--info"> @lang('Yes')</span>
                                            @else
                                                <span class="badge badge--warning"> @lang('No')</span>
                                            @endif
                                        </td>
                                        <td>
                                            @php echo $city->statusBadge; @endphp
                                        </td>
                                        @php
                                            $city->image_with_path = getImage(
                                                getFilePath('city') . '/' . $city->image,
                                                getFileSize('city'),
                                            );
                                        @endphp
                                        <td>
                                            <div class="button--group">
                                                <button class="btn btn-sm btn-outline--primary editBtn cuModalBtn"
                                                data-resource="{{ $city }}" data-modal_title="@lang('Edit City')"
                                                data-has_status="1" type="button">
                                                <i class="la la-pencil"></i>@lang('Edit')
                                            </button>
                                            @if ($city->status == Status::ENABLE)
                                                <button class="btn btn-outline--danger btn-sm confirmationBtn"
                                                    data-question="@lang('Are you sure to disable this city?')"
                                                    data-action="{{ route('admin.city.status', $city->id) }}">
                                                    <i class="las la-eye-slash"></i>@lang('Disable')
                                                </button>
                                            @else
                                                <button class="btn btn-outline--success confirmationBtn btn-sm"
                                                    data-question="@lang('Are you sure to enable this city?')"
                                                    data-action="{{ route('admin.city.status', $city->id) }}">
                                                    <i class="las la-eye"></i>@lang('Enable')
                                                </button>
                                            @endif
                                            @if ($city->is_featured == Status::CITY_FEATURED)
                                                <button class="btn btn-outline--warning btn-sm confirmationBtn"
                                                    data-question="@lang('Are you sure to unfeature this city?')"
                                                    data-action="{{ route('admin.city.feature', $city->id) }}">
                                                    <i class="las la-eye-slash"></i>@lang('Unfeature')
                                                </button>
                                            @else
                                                <button class="btn btn-outline--info confirmationBtn btn-sm"
                                                    data-question="@lang('Are you sure to feature this city?')"
                                                    data-action="{{ route('admin.city.feature', $city->id) }}">
                                                    <i class="las la-eye"></i>@lang('Feature')
                                                </button>
                                            @endif
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>

                @if ($cities->hasPages())
                    <div class="card-footer py-4">
                        @php echo paginateLinks($cities) @endphp
                    </div>
                @endif
            </div><!-- card end -->
        </div>
    </div>

    @php
        $cityImage = getImage(getFilePath('city'), getFileSize('city'));
    @endphp
    <!--Cu Modal -->
    <div class="modal fade" id="cuModal" role="dialog" tabindex="-1">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <button class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form action="{{ route('admin.city.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <x-image-uploader class="w-100" type="city" :required=false />
                        </div>
                        <div class="form-group">
                            <label>@lang('Country')</label>
                            <select class="form-control" name="country_id">
                                <option disabled selected>@lang('Select Country')</option>
                                @foreach ($countries as $country)
                                    <option value="{{ $country->id }}"> {{ __($country->name) }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label>@lang('City')</label>
                            <input class="form-control" name="name" type="text" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn--primary h-45 w-100" type="submit">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <x-confirmation-modal />
@endsection

@push('breadcrumb-plugins')
    <x-search-form />
    <button class="btn btn-sm btn-outline--primary h-45 cuModalBtn" data-modal_title="@lang('Add New City')" type="button">
        <i class="las la-plus"></i>@lang('Add New')
    </button>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";
            $(document).ready(function() {

                $(".cuModalBtn").on('click', function() {
                    $('#cuModal').find('[name=image]').attr('required', 'required');
                    $('#cuModal').find('[name=image]').closest('.form-group').find('label').first()
                        .addClass(
                            'required');
                });
                $(".editBtn").on('click', function() {
                    var resource = $(this).data('resource');
                    $('#cuModal').find('[name=image]').removeAttr('required');
                    $('#cuModal').find('[name=image]').closest('.form-group').find('label').first()
                        .removeClass(
                            'required');
                    const imagePath = @json(route('home') . '/' . getFilePath('city'));
                    var imageUrl;
                    if (resource.image) {
                        imageUrl = `${imagePath}/${resource.image}`;
                        console.log(imageUrl);
                    } else {
                        imageUrl = '{{ getImage(null, getFileSize('city')) }}';
                    }
                    $(".image-upload-preview").css({
                        "background-image": "url('" + imageUrl + "')"
                    });
                });

                $("#cuModal").on('hidden.bs.modal', function() {
                    $(this).find('.profilePicPreview').css('background-image',
                        `url('{{ $cityImage }}')`)
                })

            });
        })(jQuery);
    </script>
@endpush
